/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.recap.valores.ModeloValoresPagoLocal;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModeloValoresInformacionEstablecimiento
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacionEstablecimiento = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposComprobantes = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposTarjetas = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposProveedor = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private ModeloValoresPagoLocal modeloPagoLocal;

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarTiposIdentificacion();
            this.cargarTiposComprobantes();
            this.cargarTiposTarjetas();
            this.cargarTiposProveedor();
            this.inicializado = true;
        }
    }

    private void cargarTiposIdentificacion() {
        this.tiposIdentificacionEstablecimiento.clear();
        this.tiposIdentificacionEstablecimiento.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacionEstablecimiento.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    private void cargarTiposProveedor() {
        this.tiposProveedor.clear();
        this.tiposProveedor.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PERSONA NATURAL", (Object)"01"));
        this.tiposProveedor.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("SOCIEDAD", (Object)"02"));
    }

    private void cargarTiposComprobantes() {
        this.tiposComprobantes.clear();
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccion("5");
        for (Map.Entry comp : comprobantesObtenidos.entrySet()) {
            this.tiposComprobantes.put((String)comp.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)((String)comp.getKey())));
        }
    }

    private void cargarTiposTarjetas() {
        this.tiposTarjetas.clear();
        this.tiposTarjetas.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("AMERICAN EXPRESS", (Object)"01"));
        this.tiposTarjetas.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("DINERS CLUB", (Object)"02"));
        this.tiposTarjetas.put("04", (ElementoNombreValor<String>)new ElementoNombreValor("MASTERCARD", (Object)"04"));
        this.tiposTarjetas.put("05", (ElementoNombreValor<String>)new ElementoNombreValor("VISA", (Object)"05"));
        this.tiposTarjetas.put("07", (ElementoNombreValor<String>)new ElementoNombreValor("OTRA TARJETA", (Object)"07"));
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacionEstablecimiento() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacionEstablecimiento.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacionEstablecimiento.get(tipoIdentificacion);
    }

    public List<ElementoNombreValor<String>> getTiposComprobantes() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposComprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String tipoComprobante) {
        return StringUtil.isNullOrEmpty((String)tipoComprobante) ? null : this.tiposComprobantes.get(tipoComprobante);
    }

    public List<ElementoNombreValor<String>> getTiposTarjetas() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposTarjetas.values());
    }

    public List<ElementoNombreValor<String>> getTiposProveedor() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposProveedor.values());
    }

    public ElementoNombreValor<String> obtenerTipoTarjeta(String tipoTarjeta) {
        return StringUtil.isNullOrEmpty((String)tipoTarjeta) ? null : this.tiposTarjetas.get(tipoTarjeta);
    }

    public ModeloValoresPagoLocal getModeloPagoLocal() {
        return this.modeloPagoLocal;
    }

    public void setModeloPagoLocal(ModeloValoresPagoLocal modeloPagoLocal) {
        this.modeloPagoLocal = modeloPagoLocal;
    }

    public ElementoNombreValor<String> obtenerTipoProveedor(String tipoProveedor) {
        return StringUtil.isNullOrEmpty((String)tipoProveedor) ? null : this.tiposProveedor.get(tipoProveedor);
    }
}

